#include <bits/stdc++.h>
using namespace std;

struct Poncho { int w, v, idx; };

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, W;
    double eps;
    cin >> N >> W >> eps;
    vector<Poncho> p(N);
    int vmax = 0;
    for (int i = 0; i < N; i++) {
        cin >> p[i].w >> p[i].v;
        p[i].idx = i+1;
        vmax = max(vmax, p[i].v);
    }

    double scale = eps * vmax / N;
    if(scale < 1e-9) scale = 1.0;
    vector<int> v_scaled(N);
    for(int i=0;i<N;i++) v_scaled[i] = (int)(p[i].v/scale);

    int Vsum = accumulate(v_scaled.begin(), v_scaled.end(),0);
    vector<long long> dp(Vsum+1, LLONG_MAX/2);
    vector<int> choice(Vsum+1,-1);
    dp[0]=0;

    for(int i=0;i<N;i++){
        for(int j=Vsum;j>=v_scaled[i];j--){
            if(dp[j-v_scaled[i]] + p[i].w < dp[j]){
                dp[j] = dp[j-v_scaled[i]] + p[i].w;
            }
        }
    }

    int best = 0;
    for(int j=0;j<=Vsum;j++) if(dp[j]<=W) best = j;

    vector<int> res;
    int rem = best;
    for(int i=N-1;i>=0;i--){
        if(rem>=v_scaled[i] && dp[rem]==dp[rem-v_scaled[i]] + p[i].w){
            res.push_back(p[i].idx);
            rem -= v_scaled[i];
        }
    }

    cout << res.size() << "\n";
    for(int i=res.size()-1;i>=0;i--) cout << res[i] << (i==0?"\n":" ");
}